import os
import stat
import paramiko
from flask import Flask, request, send_file, jsonify
from weasyprint import HTML
from jinja2 import Environment, FileSystemLoader, select_autoescape
from io import BytesIO
from flask_cors import CORS

def create_app():
    app = Flask(__name__)
    CORS(app)  # CORS für Cross-Origin Requests aktivieren

    TEMPLATE_DIR = '/opt/battcheck-backend/'

    # SFTP-Konfiguration
    SFTP_HOST = 'k68e72.meinserver.io'
    SFTP_PORT = 22
    SFTP_USER = 'c323036BattArmy01'
    SFTP_PASS = 'rpr12345%'
    SFTP_DIR = '/home/c323036BattArmy01/EB-0225-001/'

    # Setup Jinja2 Environment
    env = Environment(
        loader=FileSystemLoader(TEMPLATE_DIR),
        autoescape=select_autoescape(['html', 'xml'])
    )

    @app.route('/list-files', methods=['GET'])
    def list_files():
        try:
            transport = paramiko.Transport((SFTP_HOST, SFTP_PORT))
            transport.connect(username=SFTP_USER, password=SFTP_PASS)
            sftp = paramiko.SFTPClient.from_transport(transport)

            files = []
            print("Verbindung zum SFTP-Server hergestellt.")

            for entry in sftp.listdir_attr(SFTP_DIR):
                print(f"Gefundenes Verzeichnis: {entry.filename}")

                if stat.S_ISDIR(entry.st_mode):
                    subdir_path = os.path.join(SFTP_DIR, entry.filename)
                    print(f"Durchsuche Verzeichnis: {subdir_path}")

                    # Durchsuche alle Unterverzeichnisse nach .txt-Dateien
                    for subentry in sftp.listdir_attr(subdir_path):
                        print(f"Gefundene Datei im Unterverzeichnis: {subentry.filename}")

                        if subentry.filename.endswith('.txt'):
                            file_name = subentry.filename

                            # Extrahiere die VIN aus dem Dateinamen
                            parts = file_name.replace('certificate_data_', '').split('_')
                            
                            if len(parts) < 1:
                                print(f"Überspringe Datei (unvollständiger Name): {file_name}")
                                continue

                            vin = parts[0]  # VIN extrahieren

                            # Der Zeitstempel wird aus dem Ordnernamen extrahiert
                            timestamp = entry.filename.split('-')[1] + '_' + entry.filename.split('-')[2]  # Extrahiere Zeitstempel aus Ordnernamen
                            
                            # Kombiniere nur die VIN für die Anzeige
                            display_name = vin + " - " + timestamp  # Füge den Zeitstempel hinzu

                            print(f"Gefundene Datei: {display_name}")  # Log zum Debuggen

                            files.append(display_name)

            sftp.close()
            transport.close()

            return jsonify({"files": files})

        except Exception as e:
            print(f"Fehler beim Auflisten der Dateien: {str(e)}")
            return jsonify({"error": f"Fehler beim Auflisten der Dateien: {str(e)}"}), 500

    @app.route('/get-certificate-data', methods=['GET'])
    def get_certificate_data():
        try:
            file_name = request.args.get('file').split(' - ')[0]  # Nur den reinen Dateiname (ohne Zeitstempel)
            if not file_name:
                return jsonify({"error": "Dateiname fehlt."}), 400

            transport = paramiko.Transport((SFTP_HOST, SFTP_PORT))
            transport.connect(username=SFTP_USER, password=SFTP_PASS)
            sftp = paramiko.SFTPClient.from_transport(transport)

            for entry in sftp.listdir_attr(SFTP_DIR):
                if stat.S_ISDIR(entry.st_mode):
                    subdir_path = os.path.join(SFTP_DIR, entry.filename)
                    for subentry in sftp.listdir_attr(subdir_path):
                        # Jetzt suchen wir nach dem reinen Dateinamen ohne Zeitstempel
                        if subentry.filename == f"certificate_data_{file_name}.txt":
                            file_path = os.path.join(subdir_path, subentry.filename)
                            print(f"Lese Datei: {file_path}")  # Log zum Überprüfen des Pfads

                            with sftp.open(file_path, 'r') as f:
                                lines = f.readlines()

                            data = {}
                            for line in lines:
                                print(f"Zeile aus Datei: {line.strip()}")  # Log zur Zeile in der Datei
                                parts = line.strip().split(';')
                                if len(parts) == 2:
                                    key, value = parts
                                    data[key] = value
                                    print(f"Extrahierte Daten: {key}: {value}")  # Log zum Überprüfen der extrahierten Daten
                                else:
                                    print(f"Ungültiges Format in Zeile: {line.strip()}")

                            sftp.close()
                            transport.close()

                            return jsonify(data)

            sftp.close()
            transport.close()
            return jsonify({"error": "Datei nicht gefunden."}), 404

        except Exception as e:
            print(f"Fehler beim Lesen der Datei: {str(e)}")
            return jsonify({"error": f"Fehler beim Lesen der Datei: {str(e)}"}), 500

    @app.route('/generate', methods=['POST'])
    def generate_certificate():
        try:
            data = request.json

            if not data:
                return jsonify({"error": "Keine Eingabedaten empfangen."}), 400

            operator = data.get('operator', 'Unbekannt')
            model = data.get('model', 'Unbekannt')
            plate = data.get('plate', 'Unbekannt')
            firstreg = data.get('firstreg', 'Unbekannt')
            mode = data.get('mode', 'Unbekannt')
            battery_data = data.get('data', {})

            if not battery_data:
                return jsonify({"error": "Keine Batteriedaten gefunden."}), 400

            template = env.get_template('template.html')
            rendered_html = template.render(
                operator=operator,
                model=model,
                plate=plate,
                firstreg=firstreg,
                mode=mode,
                data=battery_data
            )

            pdf_io = BytesIO()
            HTML(string=rendered_html, base_url=TEMPLATE_DIR).write_pdf(pdf_io)
            pdf_io.seek(0)

            return send_file(
                pdf_io,
                mimetype='application/pdf',
                as_attachment=True,
                download_name='zertifikat.pdf'
            )

        except Exception as e:
            print(f"Fehler beim Erzeugen des Zertifikats: {str(e)}")
            return jsonify({"error": f"Fehler beim Erzeugen des Zertifikats: {str(e)}"}), 500

    return app

if __name__ == '__main__':
    app = create_app()
    app.run(host='0.0.0.0', port=8282, debug=True)

